/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.appli.service;

import com.google.common.base.Strings;
import com.promyze.domain.entity.FileWorkshop;
import com.promyze.domain.entity.VisibleLines;
import com.promyze.domain.entity.helpers.Position;
import com.promyze.ui.notification.PromyzeNotifier;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class EclipseService {
    private static int MAX_NUMBER_OF_LINES_BEFORE = 1500;
    private static int MAX_NUMBER_OF_LINES_AFTER = 1500;
    public static final String PROMYZE_NEGATIVE_MARKER = "promyze.negative.marker";
    private static final String PROMYZE_POSITIVE_MARKER = "promyze.positive.marker";

    public static String getCurrentFileContentLimitedToNLines(ExecutionEvent event) {
        try {
            FileWorkshop file = EclipseService.getCurrentFileWorkshopWithFileContentLimitedToNLines(event);
            return file.getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getFilePath(ExecutionEvent event) {
        try {
            IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                String fileName = file.getName();
                return fileName;
            }
            System.err.println("Input is of instance " + input.getClass().getCanonicalName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getCurrentFileLang(ExecutionEvent event) {
        try {
            IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
            IEditorPart editorPart = activePage.getActiveEditor();
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                String fileExtension = file.getFileExtension();
                return fileExtension;
            }
            System.err.println("Input is of instance " + input.getClass().getCanonicalName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static FileWorkshop getCurrentFileWorkshopWithFileContentLimitedToNLines(ExecutionEvent event) {
        block6: {
            try {
                IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                if (editorPart instanceof ITextEditor) {
                    int offset = EclipseService.getCurrentLineOfCursor(editorPart);
                    String text = EclipseService.getCurrentLineOfCaret(editorPart, offset, MAX_NUMBER_OF_LINES_BEFORE, MAX_NUMBER_OF_LINES_AFTER);
                    IEditorInput input = editorPart.getEditorInput();
                    if (input instanceof FileEditorInput) {
                        IFile file = ((FileEditorInput)input).getFile();
                        String fileExtension = file.getFileExtension();
                        String fileName = file.getName();
                        return new FileWorkshop(text, fileExtension, fileName);
                    }
                }
                if (editorPart instanceof MultiPageEditorPart) {
                    MultiPageEditorPart multi = (MultiPageEditorPart)editorPart;
                    IEditorInput input = multi.getEditorInput();
                    int offset = EclipseService.getCurrentLineOfCursor(editorPart);
                    String text = EclipseService.getCurrentLineOfCaret(editorPart, offset, MAX_NUMBER_OF_LINES_BEFORE, MAX_NUMBER_OF_LINES_AFTER);
                    if (input instanceof FileEditorInput) {
                        IFile file = ((FileEditorInput)input).getFile();
                        String fileExtension = file.getFileExtension();
                        String fileName = file.getName();
                        return new FileWorkshop(text, fileExtension, fileName);
                    }
                    break block6;
                }
                PromyzeNotifier.notifyUserError("This language is not supported yet by the Eclipse plugin. Go on https://upvoty.promyze.com if you'd like to request this feature. Unsupported text editor : " + editorPart.getClass().getCanonicalName());
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Set<Class<?>> getAllExtendedOrImplementedTypesRecursively(Class<?> clazz) {
        Class<?> superClass;
        ArrayList res = new ArrayList();
        do {
            res.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length <= 0) continue;
            res.addAll(Arrays.asList(interfaces));
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaze = classArray[n2];
                res.addAll(EclipseService.getAllExtendedOrImplementedTypesRecursively(interfaze));
                ++n2;
            }
        } while ((superClass = clazz.getSuperclass()) != null && !"java.lang.Object".equals((clazz = superClass).getCanonicalName()));
        return new HashSet(res);
    }

    public static FileWorkshop getCurrentFileWorkshopWithSelection(ExecutionEvent event) {
        try {
            IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                ISelection textSelected = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                ITextSelection text = (ITextSelection)textSelected;
                String fileExtension = file.getFileExtension();
                String fileName = file.getName();
                return new FileWorkshop(text.getText(), fileExtension, fileName);
            }
            System.err.println("Could not catch selected text : Input is of instance " + input.getClass().getCanonicalName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Position getCurrentPosition(ExecutionEvent event) {
        try {
            IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                ISelection textSelected = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                ITextSelection text = (ITextSelection)textSelected;
                return new Position(0, text.getStartLine(), 0, text.getEndLine());
            }
            System.err.println("Could not catch selected text : Input is of instance " + input.getClass().getCanonicalName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Position getCurrentPositionWithFileSizeLimitationsToNLines(ExecutionEvent event) {
        try {
            IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                ISelection textSelected = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                ITextSelection text = (ITextSelection)textSelected;
                int beginLine = text.getStartLine() > MAX_NUMBER_OF_LINES_BEFORE ? MAX_NUMBER_OF_LINES_BEFORE : text.getStartLine();
                return new Position(0, beginLine, 0, beginLine + (text.getEndLine() - text.getStartLine()));
            }
            System.err.println("Could not catch selected text : Input is of instance " + input.getClass().getCanonicalName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCurrentLineWithCursorOnAndNLinesAround(ExecutionEvent event) {
        try {
            IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                ITextSelection textSelection = (ITextSelection)editorPart.getSite().getSelectionProvider().getSelection();
                int offset = textSelection.getOffset();
                int startLineNumber = textSelection.getStartLine();
                int endLineNumber = textSelection.getEndLine();
                System.err.println("offset : " + offset + ", startLineNumber " + startLineNumber + ", endLineNumber : " + endLineNumber);
            } else {
                System.err.println("Could not catch selected text : Input is of instance " + input.getClass().getCanonicalName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getCurrentLineOfCursor(IEditorPart editorPart) {
        try {
            MultiPageEditorPart multi;
            Object obj;
            ITextEditor editor = null;
            if (editorPart instanceof ITextEditor) {
                editor = (ITextEditor)editorPart;
            } else if (editorPart instanceof MultiPageEditorPart && (obj = (multi = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
                editor = (ITextEditor)obj;
            }
            if (editor != null) {
                Object adapter = editor.getAdapter(ITextOperationTarget.class);
                if (adapter instanceof ITextViewer) {
                    ITextViewer viewer = (ITextViewer)adapter;
                    int widgetCaretOffset = viewer.getTextWidget().getCaretOffset();
                    if (viewer instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                        widgetCaretOffset = extension.widgetOffset2ModelOffset(widgetCaretOffset);
                    }
                    return widgetCaretOffset;
                }
                Control control = (Control)editor.getAdapter(Control.class);
                if (control instanceof StyledText) {
                    StyledText styledText = (StyledText)control;
                    return styledText.getCaretOffset();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getCurrentLineOfCaret(IEditorPart editorPart, int offset) {
        return EclipseService.getCurrentLineOfCaret(editorPart, offset, 2, 2);
    }

    public static String getCurrentLineOfCaret(IEditorPart editorPart, int offset, int lineBefore, int lineAfter) {
        block10: {
            String text;
            int currentLine;
            block11: {
                MultiPageEditorPart multi;
                Object obj;
                ITextEditor editor = null;
                if (editorPart instanceof ITextEditor) {
                    editor = (ITextEditor)editorPart;
                } else if (editorPart instanceof MultiPageEditorPart && (obj = (multi = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
                    editor = (ITextEditor)obj;
                }
                if (editor == null) break block10;
                int caretOffset = offset;
                Object adapter = editor.getAdapter(ITextOperationTarget.class);
                if (adapter instanceof ITextViewer) {
                    ITextViewer viewer = (ITextViewer)adapter;
                    caretOffset = viewer.getTextWidget().getCaretOffset();
                    if (viewer instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                        caretOffset = extension.widgetOffset2ModelOffset(caretOffset);
                    }
                } else {
                    Control control = (Control)editor.getAdapter(Control.class);
                    if (control instanceof StyledText) {
                        StyledText styledText = (StyledText)control;
                        caretOffset = styledText.getCaretOffset();
                    }
                }
                IEditorInput input = editor.getEditorInput();
                IDocument document = editor.getDocumentProvider().getDocument((Object)input);
                currentLine = document.getLineOfOffset(offset);
                text = document.get();
                if (!Strings.isNullOrEmpty((String)text)) break block11;
                return "";
            }
            try {
                String[] lines = text.split("\n");
                return Arrays.asList(lines).subList(Math.max(0, currentLine - lineBefore), Math.min(currentLine + lineAfter, lines.length)).stream().collect(Collectors.joining("\n"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static boolean isLineContentEmpty(IEditorPart editorPart, int line) {
        try {
            MultiPageEditorPart multi;
            Object obj;
            ITextEditor editor = null;
            if (editorPart instanceof ITextEditor) {
                editor = (ITextEditor)editorPart;
            } else if (editorPart instanceof MultiPageEditorPart && (obj = (multi = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
                editor = (ITextEditor)obj;
            }
            if (editor != null) {
                IEditorInput input = editorPart.getEditorInput();
                IDocument document = editor.getDocumentProvider().getDocument((Object)input);
                return document.getLineInformation(line).getLength() == 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getFileContent(IEditorPart editorPart) {
        try {
            int offset = EclipseService.getCurrentLineOfCursor(editorPart);
            String text = EclipseService.getCurrentLineOfCaret(editorPart, offset, MAX_NUMBER_OF_LINES_BEFORE, MAX_NUMBER_OF_LINES_AFTER);
            return text;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static VisibleLines getVisibleLinesOnScreen(IEditorPart editorPart) {
        try {
            ITextOperationTarget target;
            MultiPageEditorPart multi;
            Object obj;
            if (editorPart instanceof ITextEditor) {
                ITextOperationTarget target2 = (ITextOperationTarget)editorPart.getAdapter(ITextOperationTarget.class);
                if (target2 instanceof ITextViewer) {
                    ITextViewer textViewer = (ITextViewer)target2;
                    int bottomIndex = textViewer.getBottomIndex();
                    int topIndex = textViewer.getTopIndex();
                    return new VisibleLines(topIndex, bottomIndex);
                }
            } else if (editorPart instanceof MultiPageEditorPart && (obj = (multi = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor && (target = (ITextOperationTarget)((ITextEditor)obj).getAdapter(ITextOperationTarget.class)) instanceof ITextViewer) {
                ITextViewer textViewer = (ITextViewer)target;
                int bottomIndex = textViewer.getBottomIndex();
                int topIndex = textViewer.getTopIndex();
                return new VisibleLines(topIndex, bottomIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getHierarchy(Class<?> c) {
        Set<Class<?>> hierarchies = EclipseService.getAllExtendedOrImplementedTypesRecursively(c);
        String hierarchy = "";
        for (Class<?> cl : hierarchies) {
            hierarchy = String.valueOf(hierarchy) + cl.getCanonicalName() + " ; ";
        }
        return hierarchy;
    }

    public static String getLinesBetweenPositions(IEditorPart editorPart, int start, int end) {
        block6: {
            String text;
            block7: {
                MultiPageEditorPart multi;
                Object obj;
                ITextEditor editor = null;
                if (editorPart instanceof ITextEditor) {
                    editor = (ITextEditor)editorPart;
                } else if (editorPart instanceof MultiPageEditorPart && (obj = (multi = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
                    editor = (ITextEditor)obj;
                }
                if (editor == null) break block6;
                IEditorInput input = editorPart.getEditorInput();
                IDocument document = editor.getDocumentProvider().getDocument((Object)input);
                text = document.get();
                if (!Strings.isNullOrEmpty((String)text)) break block7;
                return "";
            }
            try {
                String[] lines = text.split("\n");
                return Arrays.asList(lines).subList(Math.max(0, start), Math.min(end, lines.length - 1)).stream().collect(Collectors.joining("\n"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static void openBrowser(String url) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().createBrowser("craft-tag-reference-battle").openURL(new URL(url));
        }
        catch (MalformedURLException | PartInitException e) {
            e.printStackTrace();
        }
    }

    public static String getCurrentFilePath(IEditorPart editorPart) {
        try {
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                return file.getFullPath().toOSString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getCurrentFileLang(IEditorPart editorPart) {
        try {
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                return file.getFileExtension();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void displayNegativeMarker(IEditorPart editorPart, int line, String message) {
        EclipseService.displayMarker(editorPart, line, PROMYZE_NEGATIVE_MARKER, 1, message);
    }

    public static IMarker displayMarker(IEditorPart editorPart, int line, String markerId, int severity, String message) {
        ITextEditor[] editor = new ITextEditor[1];
        IDocument[] document = new IDocument[1];
        Display.getDefault().syncExec(() -> {
            if (editorPart instanceof ITextEditor) {
                iTextEditorArray[0] = (ITextEditor)editorPart;
            } else if (editorPart instanceof MultiPageEditorPart) {
                MultiPageEditorPart multi = (MultiPageEditorPart)editorPart;
                try {
                    Object obj = multi.getSelectedPage();
                    if (obj instanceof ITextEditor) {
                        iTextEditorArray[0] = (ITextEditor)obj;
                    }
                }
                catch (Exception e) {
                    System.err.println("Error getting selected page: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            IEditorInput input = editorPart.getEditorInput();
            if (editor[0] != null) {
                Object adapter;
                iDocumentArray[0] = editor[0].getDocumentProvider().getDocument((Object)input);
                if (document[0] == null && (adapter = editor[0].getAdapter(ITextOperationTarget.class)) instanceof ITextViewer) {
                    ITextViewer viewer = (ITextViewer)adapter;
                    iDocumentArray[0] = viewer.getDocument();
                }
            } else if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                try {
                    Throwable viewer = null;
                    Object var6_10 = null;
                    try (InputStream is = file.getContents();){
                        String contents = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        iDocumentArray[0] = new Document(contents);
                    }
                    catch (Throwable throwable) {
                        if (viewer == null) {
                            viewer = throwable;
                        } else if (viewer != throwable) {
                            viewer.addSuppressed(throwable);
                        }
                        throw viewer;
                    }
                }
                catch (Exception e) {
                    System.err.println("Error reading file contents: " + e.getMessage());
                }
            }
        });
        if (document[0] == null) {
            System.err.println("Could not obtain document - aborting marker creation");
            return null;
        }
        try {
            IRegion lineInfo = document[0].getLineInformation(line);
            int offset = lineInfo.getOffset();
            int currentLine = Math.min(document[0].getLineOfOffset(offset) + 1, document[0].getNumberOfLines());
            IRegion region = document[0].getLineInformation(document[0].getLineOfOffset(offset));
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                file.findMarkers(markerId, true, 0);
                HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
                markerAttributes.put("severity", severity);
                markerAttributes.put("message", message);
                markerAttributes.put("org.eclipse.core.resources.textmarker", message);
                markerAttributes.put("lineNumber", currentLine);
                markerAttributes.put("charStart", region.getOffset());
                markerAttributes.put("charEnd", region.getOffset() + region.getLength());
                IMarker marker = file.createMarker(markerId);
                marker.setAttributes(markerAttributes);
                file.findMarkers(markerId, true, 0);
                return marker;
            }
            System.err.println("Input is not FileEditorInput: " + input.getClass().getName());
        }
        catch (Exception e) {
            System.err.println("Error creating marker:");
            e.printStackTrace();
        }
        return null;
    }

    public static void removeMarker(IMarker marker) {
        if (marker != null) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removePositiveAndNegativeMarkers(IEditorPart editorPart) {
        if (editorPart == null) {
            return;
        }
        IEditorInput input = editorPart.getEditorInput();
        if (input == null && editorPart instanceof MultiPageEditorPart) {
            MultiPageEditorPart multiPageEditor = (MultiPageEditorPart)editorPart;
            Object obj = multiPageEditor.getSelectedPage();
            if (obj instanceof ITextEditor) {
                input = ((ITextEditor)obj).getEditorInput();
            } else {
                System.err.println("Input is not a valid ITextEditor " + obj.getClass().getCanonicalName());
            }
        }
        IFile file = null;
        if (input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        } else if (input != null) {
            file = (IFile)input.getAdapter(IFile.class);
        }
        if (file != null) {
            try {
                file.deleteMarkers(PROMYZE_POSITIVE_MARKER, true, 2);
                file.deleteMarkers(PROMYZE_NEGATIVE_MARKER, true, 2);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getNumberOfLinesInOpenEditor(IEditorPart editorPart) {
        IEditorInput input = editorPart.getEditorInput();
        IDocument document = ((ITextEditor)editorPart).getDocumentProvider().getDocument((Object)input);
        return document.getNumberOfLines();
    }
}

