/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.appli.service;

import com.promyze.appli.service.LastCraftTagNegative;
import com.promyze.domain.entity.CraftTag;
import com.promyze.domain.entity.CraftTagReference;
import com.promyze.domain.entity.FileWorkshop;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class StorageService {
    private static StorageService instance;
    private final Map<String, String> stringProperties = new HashMap<String, String>();
    private final String prefixStorage = "com.promyze.";
    private final String lastVersionStorage = "com.promyze.last_version";
    private final String lastNegativeTagPrefixStorage = "com.promyze.last_negative_craft_tag.";
    private final String craftTagIdStorage = "com.promyze.last_negative_craft_tag.id";
    private final String craftTagSpaceIdStorage = "com.promyze.last_negative_craft_tag.space_id";
    private final String craftTagPracticeNameStorage = "com.promyze.last_negative_craft_tag.practice_name";
    private final String craftTagFileNameStorage = "com.promyze.last_negative_craft_tag.file_name";
    private final String craftTagDateStorage = "com.promyze.last_negative_craft_tag.date";

    public static StorageService getInstance() {
        if (instance == null) {
            instance = new StorageService();
        }
        return instance;
    }

    public void storeCurrentVersionUsed(String currentVersion) {
        this.stringProperties.put("com.promyze.last_version", currentVersion);
    }

    public String getLastVersionUsed() {
        return this.stringProperties.get("com.promyze.last_version");
    }

    public void storeNewCraftTagNegativeAdded(CraftTag craftTag, CraftTagReference craftTagReference, FileWorkshop fileWorkshop) {
        this.stringProperties.put("com.promyze.last_negative_craft_tag.id", craftTag.get_id());
        this.stringProperties.put("com.promyze.last_negative_craft_tag.space_id", craftTag.getSpace());
        this.stringProperties.put("com.promyze.last_negative_craft_tag.practice_name", craftTagReference.getName());
        this.stringProperties.put("com.promyze.last_negative_craft_tag.file_name", fileWorkshop.getPath());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.stringProperties.put("com.promyze.last_negative_craft_tag.date", simpleDateFormat.format(new Date()));
    }

    public LastCraftTagNegative getLastCraftTagNegativeAdded() {
        String craftTagId = this.stringProperties.get("com.promyze.last_negative_craft_tag.id");
        String spaceId = this.stringProperties.get("com.promyze.last_negative_craft_tag.space_id");
        String practiceName = this.stringProperties.get("com.promyze.last_negative_craft_tag.practice_name");
        String fileName = this.stringProperties.get("com.promyze.last_negative_craft_tag.file_name");
        String date = this.stringProperties.get("com.promyze.last_negative_craft_tag.date");
        if (craftTagId != null && spaceId != null) {
            return new LastCraftTagNegative(craftTagId, spaceId, practiceName, fileName, date);
        }
        return null;
    }

    public void clearLastCraftTagNegativeAdded() {
        this.stringProperties.put("com.promyze.last_negative_craft_tag.id", null);
        this.stringProperties.put("com.promyze.last_negative_craft_tag.space_id", null);
        this.stringProperties.put("com.promyze.last_negative_craft_tag.practice_name", null);
        this.stringProperties.put("com.promyze.last_negative_craft_tag.file_name", null);
        this.stringProperties.put("com.promyze.last_negative_craft_tag.date", null);
    }
}

