/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.promyze.domain.entity.Entity;
import com.promyze.domain.entity.helpers.PositiveNegativeExamples;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CraftTagReference
extends Entity {
    private String description;
    private Set<String> categories = new HashSet<String>();
    private PositiveNegativeExamples examples;
    private String regex = "";

    public CraftTagReference() {
        super(null);
    }

    public CraftTagReference(String name) {
        super(name);
    }

    public CraftTagReference(String name, String description, String[] categories, String regex) {
        super(name);
        this.setDescription(description);
        this.setCategories(categories);
        this.setRegex(regex);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getCategories() {
        return this.categories.toArray(new String[0]);
    }

    public void setCategories(String[] categories) {
        this.categories = new HashSet<String>(Arrays.asList(categories));
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void removeCategory(String category) {
        this.categories.remove(category);
    }

    public PositiveNegativeExamples getExamples() {
        return this.examples;
    }

    public void setExamples(PositiveNegativeExamples examples) {
        this.examples = examples;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public boolean hasPositiveExamples() {
        return this.examples.getPositive().size() > 0;
    }

    public boolean hasNegativeExamples() {
        return this.examples.getNegative().size() > 0;
    }

    public boolean hasExamples() {
        return this.hasPositiveExamples() || this.hasNegativeExamples();
    }

    public String getRegex() {
        return this.regex;
    }

    public String toStringWithNameAndCategories() {
        StringBuilder categoryNames = new StringBuilder();
        if (this.categories.size() > 0) {
            String[] categories = this.getCategories();
            Arrays.sort(categories, String::compareToIgnoreCase);
            categoryNames.append(" [");
            int cpt = 1;
            String[] stringArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                categoryNames.append(category);
                if (cpt < categories.length) {
                    categoryNames.append(" - ");
                    ++cpt;
                }
                ++n2;
            }
            categoryNames.append("]");
        }
        return String.valueOf(this.name) + categoryNames.toString();
    }
}

