/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.infra.repository;

import com.promyze.appli.service.UrlService;
import com.promyze.appli.service.api.IDEApiService;
import com.promyze.domain.entity.helpers.Origin;
import com.promyze.domain.exception.AbstractPromyzeException;
import com.promyze.domain.repository.IApiRepo;
import com.promyze.domain.service.IApiService;
import com.promyze.infra.exception.ApiKeyException;
import com.promyze.infra.exception.ConnectionException;
import com.promyze.infra.exception.ForbiddenException;
import com.promyze.infra.repository.PromyzeJSONAdapters;
import com.promyze.ui.notification.PromyzeNotifier;

public final class ApiRepo
implements IApiRepo {
    private final IApiService apiService = IDEApiService.getInstance();

    @Override
    public boolean checkPromyzeApiKey() {
        try {
            this.apiService.post("check-key", PromyzeJSONAdapters.originMessage.toJson((Object)new Origin()));
            PromyzeNotifier.notifyUserSuccess("Connected to Packmind instance !");
            return true;
        }
        catch (AbstractPromyzeException e) {
            if (e instanceof ApiKeyException) {
                PromyzeNotifier.notifyPromyzeError(e);
            } else if (e instanceof ConnectionException) {
                try {
                    String serverUrl = UrlService.getRootUrlForFront();
                    PromyzeNotifier.notifyUserError("Packmind - Can't join server at: " + serverUrl);
                }
                catch (ApiKeyException apiKeyException) {
                    PromyzeNotifier.notifyUserError("Packmind - Can't join server");
                }
            } else if (e instanceof ForbiddenException) {
                PromyzeNotifier.notifyUserError("Packmind - Your API Key is not authorized");
            } else {
                PromyzeNotifier.notifyUserError("Unknown error when connecting to Packmind: " + e.getMessage());
            }
            return false;
        }
    }
}

