/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.infra.repository;

import com.promyze.appli.service.api.CommonApiService;
import com.promyze.domain.entity.CraftTagReference;
import com.promyze.domain.exception.AbstractPromyzeException;
import com.promyze.domain.repository.ICraftTagReferenceRepo;
import com.promyze.domain.service.IApiService;
import com.promyze.infra.exception.UnexpectedException;
import com.promyze.infra.repository.PromyzeJSONAdapters;
import com.promyze.ui.notification.PromyzeNotifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CraftTagReferenceRepo
implements ICraftTagReferenceRepo {
    private final String craftTagReferenceBaseUrl = "craft-tag-reference";
    private final IApiService apiService = CommonApiService.getInstance();

    @Override
    public List<CraftTagReference> getAllCraftTagReferences() {
        try {
            return (List)PromyzeJSONAdapters.craftTagJsonAdapterList.fromJson(this.apiService.get("craft-tag-reference"));
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return new ArrayList<CraftTagReference>();
        }
        catch (IOException exception) {
            PromyzeNotifier.notifyPromyzeError(new UnexpectedException(exception.getMessage()));
            return new ArrayList<CraftTagReference>();
        }
    }

    @Override
    public List<CraftTagReference> getAllCraftTagReferencesInSpace(String spaceId) {
        try {
            return (List)PromyzeJSONAdapters.craftTagJsonAdapterList.fromJson(this.apiService.get("craft-tag-reference/in-space/" + spaceId));
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return new ArrayList<CraftTagReference>();
        }
        catch (IOException exception) {
            PromyzeNotifier.notifyPromyzeError(new UnexpectedException(exception.getMessage()));
            return new ArrayList<CraftTagReference>();
        }
    }

    @Override
    public List<String> getAllCategoriesInSpace(String spaceId) {
        try {
            return (List)PromyzeJSONAdapters.stringList.fromJson(this.apiService.get("craft-tag-reference/categories/" + spaceId));
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return new ArrayList<String>();
        }
        catch (IOException exception) {
            PromyzeNotifier.notifyPromyzeError(new UnexpectedException(exception.getMessage()));
            return new ArrayList<String>();
        }
    }

    @Override
    public List<CraftTagReference> getCraftTagReferencesWithBattleOngoing() {
        try {
            return (List)PromyzeJSONAdapters.craftTagJsonAdapterList.fromJson(this.apiService.get("craft-tag-reference/battle-ongoing"));
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return new ArrayList<CraftTagReference>();
        }
        catch (IOException exception) {
            PromyzeNotifier.notifyPromyzeError(new UnexpectedException(exception.getMessage()));
            return new ArrayList<CraftTagReference>();
        }
    }

    @Override
    public CraftTagReference getCraftTagReferenceDetails(String craftTagReferenceId, String spaceId) {
        try {
            return (CraftTagReference)PromyzeJSONAdapters.craftTagJsonAdapter.fromJson(this.apiService.get("craft-tag-reference/" + spaceId + "/" + craftTagReferenceId));
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return null;
        }
        catch (IOException exception) {
            PromyzeNotifier.notifyPromyzeError(new UnexpectedException(exception.getMessage()));
            return null;
        }
    }
}

