/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.infra.repository;

import com.promyze.appli.service.api.CommonApiService;
import com.promyze.domain.entity.CraftTagWithRefPop;
import com.promyze.domain.entity.helpers.Correction;
import com.promyze.domain.exception.AbstractPromyzeException;
import com.promyze.domain.repository.ICraftTagRepo;
import com.promyze.domain.service.IApiService;
import com.promyze.infra.exception.UnexpectedException;
import com.promyze.infra.repository.PromyzeJSONAdapters;
import com.promyze.ui.notification.PromyzeNotifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CraftTagRepo
implements ICraftTagRepo {
    private final String craftTagBaseUrl = "craft-tag";
    private final IApiService apiService = CommonApiService.getInstance();

    @Override
    public List<CraftTagWithRefPop> getCraftTagsAvailableInFile(String fileName) {
        try {
            return (List)PromyzeJSONAdapters.craftTagWithRefPopList.fromJson(this.apiService.post("craft-tag/available/in-file", new FileNamePayload(fileName)));
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return new ArrayList<CraftTagWithRefPop>();
        }
        catch (IOException exception) {
            PromyzeNotifier.notifyPromyzeError(new UnexpectedException(exception.getMessage()));
            return new ArrayList<CraftTagWithRefPop>();
        }
    }

    @Override
    public void addCorrectionToCraftTag(Correction correction) throws AbstractPromyzeException {
        this.apiService.post("craft-tag/add-correction", PromyzeJSONAdapters.correction.toJson((Object)correction));
    }

    @Override
    public boolean hiddenCraftTagOnPlugin(String craftTagId, String spaceId) {
        try {
            this.apiService.put("craft-tag/hidden-on-plugin/" + spaceId + "/" + craftTagId, "");
            return true;
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return false;
        }
    }

    public static class FileNamePayload {
        private final String fileName;

        FileNamePayload(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

