/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.infra.repository;

import com.promyze.appli.service.api.BrowserApiService;
import com.promyze.appli.service.api.CommonApiService;
import com.promyze.appli.service.api.IDEApiService;
import com.promyze.domain.entity.CraftTagReferenceSuggestion;
import com.promyze.domain.entity.PracticeSuggestion;
import com.promyze.domain.exception.AbstractPromyzeException;
import com.promyze.domain.repository.ISuggestionRepo;
import com.promyze.domain.service.IApiService;
import com.promyze.infra.exception.UnexpectedException;
import com.promyze.infra.repository.PromyzeJSONAdapters;
import com.promyze.ui.notification.PromyzeNotifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class SuggestionRepo
implements ISuggestionRepo {
    private final String suggestionBaseUrl = "suggestion";
    private final IApiService browserApiService = BrowserApiService.getInstance();
    private final IApiService commonApiService = CommonApiService.getInstance();
    private final IApiService ideApiService = IDEApiService.getInstance();

    @Override
    public List<CraftTagReferenceSuggestion> getAllSuggestions(String payload) {
        try {
            return (List)PromyzeJSONAdapters.craftTagReferenceSuggestionList.fromJson(this.ideApiService.post("suggestion/all", payload));
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return new ArrayList<CraftTagReferenceSuggestion>();
        }
        catch (IOException exception) {
            PromyzeNotifier.notifyPromyzeError(new UnexpectedException(exception.getMessage()));
            return new ArrayList<CraftTagReferenceSuggestion>();
        }
    }

    @Override
    public List<PracticeSuggestion> getNegativeSuggestions(String payload) {
        try {
            String json = this.ideApiService.post("suggestion/regex/negative", payload);
            List result = (List)PromyzeJSONAdapters.practiceSuggestionList.fromJson(json);
            return result;
        }
        catch (AbstractPromyzeException abstractPromyzeException) {
            return new ArrayList<PracticeSuggestion>();
        }
        catch (IOException iOException) {
            return new ArrayList<PracticeSuggestion>();
        }
    }

    @Override
    public List<List<CraftTagReferenceSuggestion>> getNegativeSuggestionsByChunksLegacy(String payload) {
        try {
            String json = this.commonApiService.post("suggestion/by-chunks/negative", payload);
            List response = (List)PromyzeJSONAdapters.craftTagReferenceSuggestionListOfList.fromJson(json);
            ArrayList<List<CraftTagReferenceSuggestion>> result = new ArrayList<List<CraftTagReferenceSuggestion>>();
            response.forEach(list2 -> {
                boolean bl = result.add(Arrays.asList(list2));
            });
            return result;
        }
        catch (AbstractPromyzeException abstractPromyzeException) {
            try {
                List response = (List)PromyzeJSONAdapters.craftTagReferenceSuggestionListOfList.fromJson(this.browserApiService.post("suggestion/by-chunks", payload));
                ArrayList<List<CraftTagReferenceSuggestion>> result = new ArrayList<List<CraftTagReferenceSuggestion>>();
                response.forEach(list2 -> {
                    boolean bl = result.add(Arrays.asList(list2).stream().filter(s -> !s.getIsPositive()).collect(Collectors.toList()));
                });
                return result;
            }
            catch (AbstractPromyzeException | IOException exception) {
                return new ArrayList<List<CraftTagReferenceSuggestion>>();
            }
        }
        catch (IOException iOException) {
            return new ArrayList<List<CraftTagReferenceSuggestion>>();
        }
    }
}

