/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.infra.settings;

import com.promyze.appli.service.PromyzeInfraService;
import com.promyze.appli.service.api.BrowserApiService;
import com.promyze.appli.service.api.CommonApiService;
import com.promyze.appli.service.api.IDEApiService;
import com.promyze.ui.notification.PromyzeNotifier;
import java.io.IOException;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PromyzePrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected static final String PREFERENCES_PAGE = "com.promyze.com.preferences.page";

    public PromyzePrefPage() {
        super(1);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new StringFieldEditor(PREFERENCES.API_KEY.toString(), "Your Api Key", 70, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(PREFERENCES.DISABLE_SUGGESTIONS.toString(), "Disable suggestions", this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
        final ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, PREFERENCES_PAGE);
        this.setPreferenceStore((IPreferenceStore)scopedPreferenceStore);
        scopedPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String newValue = event.getNewValue() != null ? event.getNewValue().toString() : "";
                scopedPreferenceStore.putValue(event.getProperty(), newValue);
                try {
                    if (newValue != null && !newValue.equals("")) {
                        PromyzeNotifier.resetServerErrorNotification();
                        scopedPreferenceStore.save();
                        BrowserApiService.getInstance().updateHttpClient();
                        CommonApiService.getInstance().updateHttpClient();
                        IDEApiService.getInstance().updateHttpClient();
                        PromyzeInfraService.getApiRepo().checkPromyzeApiKey();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.setDescription("Packmind preferences");
    }

    public String getApiKeyValue() {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, PREFERENCES_PAGE);
        return scopedPreferenceStore.getString(PREFERENCES.API_KEY.toString());
    }

    public boolean getSuggestionsDisabled() {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, PREFERENCES_PAGE);
        return scopedPreferenceStore.getBoolean(PREFERENCES.DISABLE_SUGGESTIONS.toString());
    }

    static enum PREFERENCES {
        API_KEY,
        DISABLE_SUGGESTIONS;

    }
}

