/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.command;

import com.google.common.base.Strings;
import com.promyze.domain.entity.Space;
import com.promyze.domain.repository.ICraftTagReferenceRepo;
import com.promyze.domain.repository.ISpaceRepo;
import com.promyze.ui.command.CraftTagKindSelection;
import com.promyze.ui.notification.PromyzeNotifier;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddCraftTagDialogNewPractice
extends TitleAreaDialog {
    private static final int DESCRIPTION_MAX_LENGTH = 5000;
    private static final int REGEX_MAX_LENGTH = 100;
    private Text craftTagReferenceNameField;
    private Text craftTagReferenceDescriptionField;
    private Text craftTagReferenceRegexField;
    private Text newCategoryTextField;
    private org.eclipse.swt.widgets.List categoriesToUseList;
    private org.eclipse.swt.widgets.List existingCategoriesList;
    private CraftTagKindSelection craftTagKindSelection;
    private Space space;
    private String craftTagReferenceName;
    private String craftTagReferenceDescription;
    private String craftTagReferenceRegex;
    private String[] categories = new String[0];
    private List<Space> spaces;
    private ISpaceRepo spaceRepo;
    private ICraftTagReferenceRepo craftTagReferenceRepo;

    public AddCraftTagDialogNewPractice(Shell parentShell, ISpaceRepo spaceRepo, ICraftTagReferenceRepo craftTagReferenceRepo) {
        super(parentShell);
        this.spaceRepo = spaceRepo;
        this.craftTagReferenceRepo = craftTagReferenceRepo;
    }

    public void create() {
        super.create();
        this.setTitle("Packmind");
        this.setMessage("Send selection as an existing practice example", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.spaces = this.spaceRepo.getAllSpaces();
        if (this.spaces.isEmpty()) {
            PromyzeNotifier.notifyUserError("You don't have any space yet in your organization. Please create or join an existing space");
            area.dispose();
            return area;
        }
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.initSpaceComboList(container);
        this.initCraftTagReferenceTextNameField(container);
        this.initCraftTagReferenceTextDescriptionField(container);
        this.initCraftTagReferenceTextRegexField(container);
        this.initPositiveNegativeKind(container);
        this.initCategoriesFields(container);
        this.updateValidationButtonStatus();
        return area;
    }

    private void initPositiveNegativeKind(Composite container) {
        this.craftTagKindSelection = new CraftTagKindSelection();
        this.craftTagKindSelection.setPositiveNegativeRadioTag(container);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, "Send example to Packmind", false);
        this.getButton(0).setEnabled(false);
        this.getButton(0).setTouchEnabled(false);
    }

    private void updateValidationButtonStatus() {
        if (this.getButton(0) != null) {
            boolean enabledButton = this.space != null && !Strings.isNullOrEmpty((String)this.craftTagReferenceName);
            this.getButton(0).setEnabled(enabledButton);
        } else {
            System.err.println("OK_ID button is null");
        }
    }

    public void initSpaceComboList(Composite container) {
        Label spaceLabel = new Label(container, 0);
        spaceLabel.setText("Space");
        Combo spacesList = new Combo(container, 4);
        GridData dataSpace = new GridData();
        dataSpace.grabExcessHorizontalSpace = true;
        dataSpace.horizontalAlignment = 4;
        spacesList.setLayoutData((Object)dataSpace);
        this.spaces.stream().sorted((s1, s2) -> s1.getName().compareTo(s2.getName())).forEach(s -> spacesList.add(s.getName()));
        spacesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddCraftTagDialogNewPractice.this.space = AddCraftTagDialogNewPractice.this.getSpaceFromName(((Combo)e.getSource()).getText());
                if (AddCraftTagDialogNewPractice.this.space != null) {
                    AddCraftTagDialogNewPractice.this.updateCategoriesList(AddCraftTagDialogNewPractice.this.space);
                }
                AddCraftTagDialogNewPractice.this.updateValidationButtonStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Space getSpaceFromName(String spaceName) {
        if (Strings.isNullOrEmpty((String)spaceName)) {
            return null;
        }
        return this.spaces.stream().filter(s -> s.getName().equals(spaceName)).findFirst().get();
    }

    public void initCraftTagReferenceTextNameField(Composite container) {
        Label craftTagLabel = new Label(container, 0);
        craftTagLabel.setText("Name your Practice");
        this.craftTagReferenceNameField = new Text(container, 2048);
        this.craftTagReferenceNameField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                AddCraftTagDialogNewPractice.this.updateCraftTagReferenceName();
                AddCraftTagDialogNewPractice.this.updateValidationButtonStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        GridData dataCraftTagReference = new GridData();
        dataCraftTagReference.grabExcessHorizontalSpace = true;
        dataCraftTagReference.horizontalAlignment = 4;
        this.craftTagReferenceNameField.setLayoutData((Object)dataCraftTagReference);
    }

    public void initCraftTagReferenceTextDescriptionField(Composite container) {
        Label craftTagLabel = new Label(container, 0);
        craftTagLabel.setText("Description");
        this.craftTagReferenceDescriptionField = new Text(container, 2562);
        this.craftTagReferenceDescriptionField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.craftTagReferenceDescriptionField.setTextLimit(5000);
        this.craftTagReferenceDescriptionField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                AddCraftTagDialogNewPractice.this.updateCraftTagReferenceDescription();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        GridData dataCraftTagReference = new GridData();
        dataCraftTagReference.grabExcessHorizontalSpace = true;
        dataCraftTagReference.horizontalAlignment = 4;
        dataCraftTagReference.heightHint = 5 * this.craftTagReferenceDescriptionField.getLineHeight();
        this.craftTagReferenceDescriptionField.setLayoutData((Object)dataCraftTagReference);
    }

    public void initCraftTagReferenceTextRegexField(Composite container) {
        Label craftTagRegexLabel = new Label(container, 0);
        craftTagRegexLabel.setText("Specify a regex to identify negatively this practice (optional) :");
        this.craftTagReferenceRegexField = new Text(container, 2562);
        this.craftTagReferenceRegexField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.craftTagReferenceRegexField.setTextLimit(100);
        this.craftTagReferenceRegexField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                AddCraftTagDialogNewPractice.this.updateCraftTagReferenceRegex();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        GridData dataCraftTagReference = new GridData();
        dataCraftTagReference.grabExcessHorizontalSpace = true;
        dataCraftTagReference.horizontalAlignment = 4;
        dataCraftTagReference.heightHint = 5 * this.craftTagReferenceRegexField.getLineHeight();
        this.craftTagReferenceRegexField.setLayoutData((Object)dataCraftTagReference);
    }

    private void updateCraftTagReferenceName() {
        this.craftTagReferenceName = this.craftTagReferenceNameField.getText();
    }

    private void updateCraftTagReferenceDescription() {
        this.craftTagReferenceDescription = this.craftTagReferenceDescriptionField.getText();
    }

    private void updateCraftTagReferenceRegex() {
        this.craftTagReferenceRegex = this.craftTagReferenceRegexField.getText();
    }

    private void updateCategoriesList(Space space) {
        if (space != null) {
            this.existingCategoriesList.removeAll();
            List<String> categoriesInSpace = this.craftTagReferenceRepo.getAllCategoriesInSpace(space.get_id());
            for (String category : categoriesInSpace) {
                this.existingCategoriesList.add(category);
            }
        }
    }

    private void initCategoriesFields(Composite container) {
        this.initNewCategoryField(container);
        this.initCurrentCategoriesForCraftTagReference(container);
        this.initExistingCategoriesInSpace(container);
        this.updateCategoriesList(this.space);
    }

    private void initCurrentCategoriesForCraftTagReference(Composite container) {
        Label categoriesLabel = new Label(container, 0);
        categoriesLabel.setText("Current Categories (double click to remove)");
        this.categoriesToUseList = new org.eclipse.swt.widgets.List(container, 2562);
        this.categoriesToUseList.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.categoriesToUseList.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                String selectedCategory = AddCraftTagDialogNewPractice.this.categoriesToUseList.getSelection()[0];
                AddCraftTagDialogNewPractice.this.removeCategoryToList(selectedCategory);
            }
        });
    }

    private void initExistingCategoriesInSpace(Composite container) {
        Label existingCategoriesLabel = new Label(container, 0);
        existingCategoriesLabel.setText("Existing Categories (double click to add)");
        this.existingCategoriesList = new org.eclipse.swt.widgets.List(container, 2562);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.heightHint = 5 * this.existingCategoriesList.getItemHeight();
        this.existingCategoriesList.setLayoutData((Object)data);
        this.existingCategoriesList.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (AddCraftTagDialogNewPractice.this.existingCategoriesList.getSelection().length > 0) {
                    String selectedCategory = AddCraftTagDialogNewPractice.this.existingCategoriesList.getSelection()[0];
                    AddCraftTagDialogNewPractice.this.addCategoryToList(selectedCategory);
                }
            }
        });
    }

    private void initNewCategoryField(Composite container) {
        Label existingCategoriesLabel = new Label(container, 0);
        existingCategoriesLabel.setText("Add new Category");
        Group addNewCategory = new Group(container, 0);
        addNewCategory.setLayout((Layout)new RowLayout(256));
        this.newCategoryTextField = new Text((Composite)addNewCategory, 2048);
        Button addNewCategoryButton = new Button((Composite)addNewCategory, 8);
        addNewCategoryButton.setText("Add category");
        addNewCategoryButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                AddCraftTagDialogNewPractice.this.addNewCategoryToList();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void addNewCategoryToList() {
        String newCategory = this.newCategoryTextField.getText();
        this.newCategoryTextField.setText("");
        this.addCategoryToList(newCategory);
    }

    private void addCategoryToList(String category) {
        if (!Strings.isNullOrEmpty((String)category) && !Arrays.asList(this.categoriesToUseList.getItems()).contains(category)) {
            this.categoriesToUseList.add(category);
            this.categories = this.categoriesToUseList.getItems();
        }
    }

    private void removeCategoryToList(String category) {
        if (!Strings.isNullOrEmpty((String)category) && Arrays.asList(this.categoriesToUseList.getItems()).contains(category)) {
            this.categoriesToUseList.remove(category);
            this.categories = this.categoriesToUseList.getItems();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public Space getSpace() {
        return this.space;
    }

    public String getCraftTagReferenceName() {
        return this.craftTagReferenceName;
    }

    public String getCraftTagReferenceDescription() {
        return this.craftTagReferenceDescription;
    }

    public String getCraftTagReferenceRegex() {
        return this.craftTagReferenceRegex;
    }

    public boolean isPositive() {
        return this.craftTagKindSelection.isCurrentCraftTagPositive();
    }

    public String[] getCategories() {
        return this.categories;
    }
}

