/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.menu;

import com.promyze.appli.service.EclipseService;
import com.promyze.appli.service.LastCraftTagNegative;
import com.promyze.appli.service.PromyzeInfraService;
import com.promyze.appli.service.StorageService;
import com.promyze.domain.entity.helpers.Correction;
import com.promyze.domain.exception.AbstractPromyzeException;
import com.promyze.infra.exception.ApiKeyException;
import com.promyze.infra.exception.NotFoundException;
import com.promyze.ui.PromyzeCommand;
import com.promyze.ui.notification.PromyzeNotifier;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SendCorrectionToPreviousNegativeTag
extends PromyzeCommand
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PromyzeNotifier.resetServerErrorNotification();
        if (!this.isPromyzeConfigured()) {
            PromyzeNotifier.notifyPromyzeError(new ApiKeyException());
            return null;
        }
        LastCraftTagNegative lastNegativeCraftTag = StorageService.getInstance().getLastCraftTagNegativeAdded();
        if (lastNegativeCraftTag == null) {
            PromyzeNotifier.notifyUserWarning("We could not find any previous negative example.");
            return null;
        }
        boolean result = this.askUserConfirmationToSendCorrection(lastNegativeCraftTag);
        if (result) {
            this.sendCraftTagCorrection(event, lastNegativeCraftTag);
        }
        return null;
    }

    private void sendCraftTagCorrection(ExecutionEvent event, LastCraftTagNegative lastNegativeCraftTag) {
        String craftTagId = lastNegativeCraftTag.get_id();
        String spaceId = lastNegativeCraftTag.getSpaceId();
        String contentFile = EclipseService.getCurrentFileContentLimitedToNLines(event);
        Correction correction = new Correction(craftTagId, spaceId, contentFile);
        try {
            PromyzeNotifier.resetServerErrorNotification();
            PromyzeInfraService.getCraftTagRepo().addCorrectionToCraftTag(correction);
            PromyzeNotifier.notifyUserSuccess("Correction added !");
        }
        catch (AbstractPromyzeException exception) {
            if (exception instanceof NotFoundException) {
                StorageService.getInstance().clearLastCraftTagNegativeAdded();
                PromyzeNotifier.notifyUserError("Correction not added... Negative example not found.");
            }
            PromyzeNotifier.notifyPromyzeError(exception);
        }
    }

    private boolean askUserConfirmationToSendCorrection(LastCraftTagNegative lastNegativeCraftTag) {
        boolean result = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Send Correction to Last Negative Tag", (String)("Do you want to add current changes as a new correction to the negative tag \"" + lastNegativeCraftTag.getPracticeName() + "\" for \"" + lastNegativeCraftTag.getFileName() + "\" created on " + lastNegativeCraftTag.getDate() + " ?"));
        return result;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }
}

