/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.menu;

import com.google.common.base.Strings;
import com.promyze.appli.service.EclipseService;
import com.promyze.appli.service.PromyzeInfraService;
import com.promyze.appli.service.StorageService;
import com.promyze.domain.entity.CraftTag;
import com.promyze.domain.entity.CraftTagReference;
import com.promyze.domain.entity.FileWorkshop;
import com.promyze.domain.entity.Space;
import com.promyze.domain.entity.helpers.Position;
import com.promyze.infra.exception.ApiKeyException;
import com.promyze.ui.PromyzeCommand;
import com.promyze.ui.command.AddCraftTagDialogExistingPractice;
import com.promyze.ui.dialog.TagPracticeDialogResult;
import com.promyze.ui.notification.PromyzeNotifier;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.ui.PlatformUI;

public class TagSelectionAsExistingPracticeExample
extends PromyzeCommand
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PromyzeNotifier.resetServerErrorNotification();
        if (!this.isPromyzeConfigured()) {
            PromyzeNotifier.notifyPromyzeError(new ApiKeyException());
            return null;
        }
        FileWorkshop selectionFromEditor = EclipseService.getCurrentFileWorkshopWithSelection(event);
        if (selectionFromEditor == null || Strings.isNullOrEmpty((String)selectionFromEditor.getContent())) {
            PromyzeNotifier.notifyUserError("You didn't select any lines of code, so we can't tag this as an example. Please first select one or multiple lines of code.");
            return null;
        }
        AddCraftTagDialogExistingPractice craftTagDialog = new AddCraftTagDialogExistingPractice(PlatformUI.getWorkbench().getDisplay().getActiveShell(), PromyzeInfraService.getSpaceRepo(), PromyzeInfraService.getCraftTagReferenceRepo());
        craftTagDialog.create();
        if (craftTagDialog.open() == 0) {
            this.sendCraftTagToPromyze(craftTagDialog.getSpace(), craftTagDialog.getCraftTagReference(), craftTagDialog.isPositive(), EclipseService.getCurrentFileWorkshopWithFileContentLimitedToNLines(event), EclipseService.getCurrentPositionWithFileSizeLimitationsToNLines(event));
        }
        return null;
    }

    private void sendCraftTagToPromyze(Space space, CraftTagReference craftTagReference, boolean positive, FileWorkshop fileWorkshop, Position position) {
        PromyzeNotifier.resetServerErrorNotification();
        CraftTag tag = new CraftTag(craftTagReference.get_id(), positive, position, space.get_id());
        TagPracticeDialogResult tagPracticeDialogResult = new TagPracticeDialogResult(tag, craftTagReference, fileWorkshop);
        String craftId = PromyzeInfraService.getSpaceRepo().addPracticeToSession(tagPracticeDialogResult);
        if (!Strings.isNullOrEmpty((String)craftId)) {
            PromyzeNotifier.notifyUserSuccess("Your example has been successfully sent to Packmind");
            if (!positive) {
                CraftTag newCraftTag = tagPracticeDialogResult.getCraftTag();
                newCraftTag.set_id(craftId);
                StorageService storageService = StorageService.getInstance();
                storageService.storeNewCraftTagNegativeAdded(newCraftTag, tagPracticeDialogResult.getCraftTagReference(), fileWorkshop);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }
}

