/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.menu;

import com.google.common.base.Strings;
import com.promyze.appli.service.EclipseService;
import com.promyze.appli.service.PromyzeInfraService;
import com.promyze.appli.service.StorageService;
import com.promyze.domain.entity.CraftTag;
import com.promyze.domain.entity.CraftTagReference;
import com.promyze.domain.entity.FileWorkshop;
import com.promyze.domain.entity.Space;
import com.promyze.infra.exception.ApiKeyException;
import com.promyze.ui.PromyzeCommand;
import com.promyze.ui.command.AddCraftTagDialogNewPractice;
import com.promyze.ui.dialog.TagPracticeDialogResult;
import com.promyze.ui.notification.PromyzeNotifier;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.ui.PlatformUI;

public class TagSelectionAsNewPracticeExample
extends PromyzeCommand
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PromyzeNotifier.resetServerErrorNotification();
        if (!this.isPromyzeConfigured()) {
            PromyzeNotifier.notifyPromyzeError(new ApiKeyException());
            return null;
        }
        FileWorkshop selectionFromEditor = EclipseService.getCurrentFileWorkshopWithSelection(event);
        if (selectionFromEditor == null || Strings.isNullOrEmpty((String)selectionFromEditor.getContent())) {
            PromyzeNotifier.notifyUserError("You didn't select any lines of code, so we can't tag this as an example. Please first select one or multiple lines of code.");
            return null;
        }
        AddCraftTagDialogNewPractice craftTagDialog = new AddCraftTagDialogNewPractice(PlatformUI.getWorkbench().getDisplay().getActiveShell(), PromyzeInfraService.getSpaceRepo(), PromyzeInfraService.getCraftTagReferenceRepo());
        craftTagDialog.create();
        if (craftTagDialog.open() == 0) {
            CraftTagReference newCraftTagReference = new CraftTagReference(craftTagDialog.getCraftTagReferenceName(), craftTagDialog.getCraftTagReferenceDescription(), craftTagDialog.getCategories(), craftTagDialog.getCraftTagReferenceRegex());
            CraftTag craftTag = new CraftTag(craftTagDialog.isPositive(), EclipseService.getCurrentPositionWithFileSizeLimitationsToNLines(event), craftTagDialog.getSpace().get_id());
            this.sendCraftTagToPromyze(craftTagDialog.getSpace(), craftTag, newCraftTagReference, EclipseService.getCurrentFileWorkshopWithFileContentLimitedToNLines(event));
        }
        return null;
    }

    private void sendCraftTagToPromyze(Space space, CraftTag craft, CraftTagReference newCraftTagReference, FileWorkshop fileWorkshop) {
        TagPracticeDialogResult tagPracticeDialogResult = new TagPracticeDialogResult(craft, newCraftTagReference, fileWorkshop);
        PromyzeNotifier.resetServerErrorNotification();
        String craftId = PromyzeInfraService.getSpaceRepo().addPracticeToSession(tagPracticeDialogResult);
        if (!Strings.isNullOrEmpty((String)craftId)) {
            PromyzeNotifier.notifyUserSuccess("Your example has been successfully sent to Packmind");
            if (!craft.getIsPositive()) {
                CraftTag newCraftTag = tagPracticeDialogResult.getCraftTag();
                newCraftTag.set_id(craftId);
                StorageService storageService = StorageService.getInstance();
                storageService.storeNewCraftTagNegativeAdded(newCraftTag, tagPracticeDialogResult.getCraftTagReference(), fileWorkshop);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }
}

