/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.suggestions;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.promyze.appli.service.EclipseService;
import com.promyze.appli.service.JsonRequestService;
import com.promyze.appli.service.PromyzeInfraService;
import com.promyze.domain.entity.CraftTagReferenceSuggestion;
import com.promyze.domain.entity.Entity;
import com.promyze.domain.entity.PracticeSuggestion;
import com.promyze.domain.entity.VisibleLines;
import com.promyze.domain.repository.ISuggestionRepo;
import com.promyze.infra.settings.PromyzePrefPage;
import com.promyze.ui.tabview.SuggestionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class SuggestionsManager {
    private static SuggestionsManager instance;
    private PromyzePrefPage prefPage = new PromyzePrefPage();
    private static final long SUGGESTION_CALL_DELAY_MS = 3000L;
    private final int SUGGESTIONS_CHUNK_SIZE = 1000;
    private long lastSuggestionCallTimeEditor = 0L;
    private VisibleLines lastVisibleLines = null;
    private Set<IEditorPart> cacheCaretListenerEditor = new HashSet<IEditorPart>();
    private ISuggestionRepo suggestionRepo = PromyzeInfraService.getSuggestionRepo();
    private PromyzePrefPage promyzePrefPage = new PromyzePrefPage();
    private List<SuggestionListener> suggestionsListeners = new ArrayList<SuggestionListener>();

    public static SuggestionsManager getInstance() {
        if (instance == null) {
            instance = new SuggestionsManager();
        }
        return instance;
    }

    private SuggestionsManager() {
    }

    public void addWindowListener(IWorkbenchWindow window) {
        window.getPartService().addPartListener(this.getPartListener());
    }

    public void addSuggestionListener(SuggestionListener suggestionListener) {
        this.suggestionsListeners.add(suggestionListener);
    }

    private IPartListener2 getPartListener() {
        return new IPartListener2(){

            public void partOpened(IWorkbenchPartReference partRef) {
                SuggestionsManager.this.addCaretListenerToEditor(partRef);
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                SuggestionsManager.this.addCaretListenerToEditor(partRef);
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
    }

    private void addCaretListenerToEditor(IWorkbenchPartReference partRef) {
        IEditorPart editor = partRef.getPage().getActiveEditor();
        if (editor != null) {
            this.cacheCaretListenerEditor.add(editor);
            StyledText sText = (StyledText)editor.getAdapter(Control.class);
            if (sText != null) {
                sText.addCaretListener(this.getCaretListener(editor));
                sText.addMouseWheelListener(this.getMouseWheelListener(editor));
            }
        } else {
            IEditorReference editorRef;
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof IEditorPart && partRef instanceof IEditorReference && (editor = (editorRef = (IEditorReference)partRef).getEditor(true)) != null && !this.cacheCaretListenerEditor.contains(editor)) {
                this.cacheCaretListenerEditor.add(editor);
                StyledText sText = (StyledText)editor.getAdapter(Control.class);
                if (sText != null) {
                    sText.addCaretListener(this.getCaretListener(editor));
                    sText.addMouseWheelListener(this.getMouseWheelListener(editor));
                }
            }
        }
    }

    private CaretListener getCaretListener(final IEditorPart editor) {
        return new CaretListener(){

            public void caretMoved(CaretEvent event) {
                SuggestionsManager.this.refreshSuggestionsBasedOnCurrentCaret(editor);
            }
        };
    }

    private void refreshSuggestionsBasedOnCurrentCaret(IEditorPart editor) {
        if (this.suggestionsAreDisabled() || !this.isPromyzeConfigured()) {
            return;
        }
        long now = new Date().getTime();
        if (now - this.lastSuggestionCallTimeEditor < 3000L) {
            return;
        }
        String path = EclipseService.getCurrentFilePath(editor);
        String extension = EclipseService.getCurrentFileLang(editor);
        this.refreshNegativeSuggestions(editor, path, extension);
    }

    private void refreshNegativeSuggestions(final IEditorPart editor, final String path, final String extension) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String lines = EclipseService.getFileContent(editor);
                if (lines.equals("")) {
                    return;
                }
                Job job = SuggestionsManager.this.buildJobGetNegativeSuggestions(editor, lines, path, extension);
                job.schedule();
            }
        });
    }

    private void refreshNegativeSuggestionsByChunkBasedVisibleLines(final IEditorPart editor, final String path, final String extension) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                VisibleLines currentVisibleLines = EclipseService.getVisibleLinesOnScreen(editor);
                if (currentVisibleLines == null || SuggestionsManager.this.lastVisibleLines != null && Math.abs(currentVisibleLines.start - ((SuggestionsManager)SuggestionsManager.this).lastVisibleLines.start) <= 1000) {
                    return;
                }
                String lines = EclipseService.getLinesBetweenPositions(editor, currentVisibleLines.start, currentVisibleLines.end);
                SuggestionsManager.this.lastVisibleLines = currentVisibleLines;
                Job job = SuggestionsManager.this.buildJobGetNegativeSuggestionsByChunksLegacy(editor, lines, path, extension);
                job.schedule();
            }
        });
    }

    private void refreshSuggestionsForVisibleLinesInEditor(IEditorPart editor) {
        if (this.suggestionsAreDisabled() || !this.isPromyzeConfigured()) {
            return;
        }
        long now = new Date().getTime();
        if (now - this.lastSuggestionCallTimeEditor < 3000L) {
            return;
        }
        String path = EclipseService.getCurrentFilePath(editor);
        String extension = EclipseService.getCurrentFileLang(editor);
        this.refreshNegativeSuggestions(editor, path, extension);
    }

    private MouseWheelListener getMouseWheelListener(final IEditorPart editor) {
        return new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                SuggestionsManager.this.refreshSuggestionsForVisibleLinesInEditor(editor);
            }
        };
    }

    private Job buildJobGetNegativeSuggestions(final IEditorPart editor, final String lines, final String path, final String extension) {
        Job job = new Job("Refresh suggestion"){

            protected IStatus run(IProgressMonitor monitor) {
                List<PracticeSuggestion> suggestions = SuggestionsManager.this.getPracticeSuggestions(lines, path, extension);
                SuggestionsManager.this.lastSuggestionCallTimeEditor = new Date().getTime();
                this.refreshEditorWithGutters(suggestions);
                return Status.OK_STATUS;
            }

            void refreshEditorWithGutters(List<PracticeSuggestion> suggestions) {
                EclipseService.removePositiveAndNegativeMarkers(editor);
                for (PracticeSuggestion suggestion : suggestions) {
                    int[] nArray = suggestion.getLines();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int line = nArray[n2];
                        String negativeSuggestions = this.concatenateSuggestions(suggestion);
                        EclipseService.displayNegativeMarker(editor, line, negativeSuggestions);
                        ++n2;
                    }
                }
            }

            private String concatenateSuggestions(PracticeSuggestion suggestion) {
                return suggestion.getName();
            }
        };
        return job;
    }

    private Job buildJobGetNegativeSuggestionsByChunksLegacy(final IEditorPart editor, final String lines, final String path, final String extension) {
        Job job = new Job("Refresh suggestion - Negative Chunks"){

            protected IStatus run(IProgressMonitor monitor) {
                List<PracticeSuggestion> suggestions = SuggestionsManager.this.getPracticeSuggestions(lines, path, extension);
                SuggestionsManager.this.lastSuggestionCallTimeEditor = new Date().getTime();
                this.refreshEditorWithGutters(suggestions);
                return Status.OK_STATUS;
            }

            void refreshEditorWithGutters(List<PracticeSuggestion> suggestions) {
                EclipseService.removePositiveAndNegativeMarkers(editor);
                for (PracticeSuggestion suggestion : suggestions) {
                    int[] nArray = suggestion.getLines();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int line = nArray[n2];
                        String negativeSuggestions = this.concatenateSuggestions(suggestion);
                        EclipseService.displayNegativeMarker(editor, line, negativeSuggestions);
                        ++n2;
                    }
                }
            }

            private String concatenateSuggestions(PracticeSuggestion suggestion) {
                return suggestion.getName();
            }

            private String concatenateSuggestions(List<CraftTagReferenceSuggestion> suggestions) {
                if (suggestions.isEmpty()) {
                    return "";
                }
                if (suggestions.size() == 1) {
                    return suggestions.get(0).getName();
                }
                return "(" + suggestions.size() + " suggestions) " + suggestions.stream().map(Entity::getName).collect(Collectors.joining(" - "));
            }
        };
        return job;
    }

    public List<CraftTagReferenceSuggestion> getDataForAllSuggestions(String sourceCode, String path, String extension) {
        if (Strings.isNullOrEmpty((String)sourceCode) || Strings.isNullOrEmpty((String)sourceCode.trim())) {
            return new ArrayList<CraftTagReferenceSuggestion>();
        }
        JsonObject requestBody = this.getRequestBodyForPracticeSuggestions(sourceCode, path, extension);
        if (requestBody == null) {
            return new ArrayList<CraftTagReferenceSuggestion>();
        }
        List<CraftTagReferenceSuggestion> suggestions = this.suggestionRepo.getAllSuggestions(requestBody.toString());
        return suggestions;
    }

    public List<PracticeSuggestion> getPracticeSuggestions(String sourceCode, String path, String extension) {
        if (Strings.isNullOrEmpty((String)sourceCode) || Strings.isNullOrEmpty((String)sourceCode.trim())) {
            return new ArrayList<PracticeSuggestion>();
        }
        JsonObject requestBody = this.getRequestBodyForPracticeSuggestions(sourceCode, path, extension);
        if (requestBody == null) {
            return new ArrayList<PracticeSuggestion>();
        }
        List<PracticeSuggestion> suggestions = this.suggestionRepo.getNegativeSuggestions(requestBody.toString());
        return suggestions;
    }

    public List<List<CraftTagReferenceSuggestion>> getDataNegativeSuggestionsByChunk(String sourceCode, String path, String extension) {
        if (Strings.isNullOrEmpty((String)sourceCode) || Strings.isNullOrEmpty((String)sourceCode.trim())) {
            return new ArrayList<List<CraftTagReferenceSuggestion>>();
        }
        JsonObject requestBody = this.getRequestBodyForPracticeSuggestions(sourceCode, path, extension);
        if (requestBody == null) {
            return new ArrayList<List<CraftTagReferenceSuggestion>>();
        }
        List<List<CraftTagReferenceSuggestion>> suggestions = this.suggestionRepo.getNegativeSuggestionsByChunksLegacy(requestBody.toString());
        return suggestions;
    }

    private JsonObject getRequestBodyForPracticeSuggestions(String sourceCode, String path, String extension) {
        return JsonRequestService.getRequestBodyForSuggestions(sourceCode, path, extension);
    }

    private boolean suggestionsAreDisabled() {
        return this.promyzePrefPage.getSuggestionsDisabled();
    }

    protected boolean isPromyzeConfigured() {
        return !Strings.isNullOrEmpty((String)this.prefPage.getApiKeyValue());
    }
}

