/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.tabview;

import com.promyze.appli.service.PromyzeInfraService;
import com.promyze.domain.entity.CraftTagReference;
import com.promyze.domain.entity.helpers.PositiveNegativeExamples;
import com.promyze.domain.repository.ICraftTagReferenceRepo;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class CraftTagReferenceDetail
extends Dialog {
    private CraftTagReference craftTagReference;
    private Composite container;

    public CraftTagReferenceDetail(Shell parentShell, CraftTagReference craftTagReference) {
        super(parentShell);
        this.craftTagReference = craftTagReference;
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        this.addCraftTagReferenceDescription();
        ICraftTagReferenceRepo repo = PromyzeInfraService.getCraftTagReferenceRepo();
        CraftTagReference craftTagReferenceWithExamples = repo.getCraftTagReferenceDetails(this.craftTagReference.get_id(), this.craftTagReference.getSpace().get_id());
        if (craftTagReferenceWithExamples != null) {
            this.addExamples(craftTagReferenceWithExamples);
        }
        return this.container;
    }

    private void addCraftTagReferenceDescription() {
        Label craftTagReferenceLabel = new Label(this.container, 0);
        craftTagReferenceLabel.setText(this.craftTagReference.getName());
        FontData[] fontdata = craftTagReferenceLabel.getFont().getFontData();
        fontdata[0].setHeight(16);
        craftTagReferenceLabel.setFont(new Font((Device)craftTagReferenceLabel.getDisplay(), fontdata[0]));
        Browser browser = new Browser(this.container, 2560);
        GridData gridData = new GridData(4, 1, true, true);
        gridData.heightHint = 150;
        browser.setLayoutData((Object)gridData);
        browser.setText(this.craftTagReference.getDescription());
    }

    private void addExamples(CraftTagReference craftTagReferenceWithExamples) {
        this.addPositiveExamples(craftTagReferenceWithExamples);
        this.addNegativeExamples(craftTagReferenceWithExamples);
    }

    private void addPositiveExamples(CraftTagReference craftTagReferenceWithExamples) {
        if (craftTagReferenceWithExamples.hasPositiveExamples()) {
            Label positiveExamples = new Label(this.container, 0);
            positiveExamples.setText("Positive Examples");
            TabFolder folder = this.buildTabComponent();
            int i = 0;
            while (i < craftTagReferenceWithExamples.getExamples().getPositive().size()) {
                TabItem example = new TabItem(folder, 2564);
                example.setText("Example " + (i + 1));
                example.setControl(this.displaySourceCode(craftTagReferenceWithExamples.getExamples().getPositive().get(i), (Composite)folder));
                ++i;
            }
        }
    }

    private void addNegativeExamples(CraftTagReference craftTagReferenceWithExamples) {
        if (craftTagReferenceWithExamples.hasNegativeExamples()) {
            Label positiveExamples = new Label(this.container, 4);
            positiveExamples.setText("Negative Examples");
            TabFolder folder = this.buildTabComponent();
            int i = 0;
            while (i < craftTagReferenceWithExamples.getExamples().getNegative().size()) {
                TabItem example = new TabItem(folder, 2564);
                example.setText("Example " + (i + 1));
                example.setControl(this.displaySourceCode(craftTagReferenceWithExamples.getExamples().getNegative().get(i), (Composite)folder));
                ++i;
            }
        }
    }

    private TabFolder buildTabComponent() {
        TabFolder folder = new TabFolder(this.container, 0);
        GridData gridData = new GridData(2052, 4, true, true);
        gridData.heightHint = 200;
        folder.setLayoutData((Object)gridData);
        return folder;
    }

    private Control displaySourceCode(PositiveNegativeExamples.Example example, Composite container) {
        StyledText text = new StyledText(container, 2624);
        text.setLayoutData((Object)new GridData(2820, 1, true, true));
        text.setText(example.getExampleContent());
        return text;
    }

    protected boolean isResizable() {
        return true;
    }

    @Focus
    public void setFocus() {
        this.container.setFocus();
    }

    protected Point getInitialSize() {
        return new Point(950, 900);
    }
}

