/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.tabview;

import com.google.common.base.Strings;
import com.promyze.domain.entity.CraftTagReference;
import com.promyze.domain.repository.ICraftTagReferenceRepo;
import com.promyze.infra.settings.PromyzePrefPage;
import com.promyze.ui.tabview.CraftTagReferenceDetail;
import com.promyze.ui.tabview.CraftTagReferenceFilter;
import com.promyze.ui.tabview.TabItemListener;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class CraftTagReferenceList
extends ViewPart
implements TabItemListener {
    private ICraftTagReferenceRepo craftTagReferenceRepo;
    private Composite compositeParent;
    private Group group;
    private TableViewer viewer;
    private CraftTagReferenceFilter practiceFilter = new CraftTagReferenceFilter();
    private PromyzePrefPage promyzePrefPage = new PromyzePrefPage();

    public CraftTagReferenceList(ICraftTagReferenceRepo craftTagReferenceRepo) {
        this.craftTagReferenceRepo = craftTagReferenceRepo;
    }

    public void createPartControl(Composite parent) {
        this.compositeParent = parent;
        this.createPracticesListComponent();
        this.refreshCraftTagReferencesList();
    }

    protected boolean isPromyzeConfigured() {
        return !Strings.isNullOrEmpty((String)this.promyzePrefPage.getApiKeyValue());
    }

    private void refreshCraftTagReferencesList() {
        if (!this.isPromyzeConfigured()) {
            return;
        }
        Job job = new Job("Refresh Craft Tag References"){

            protected IStatus run(IProgressMonitor monitor) {
                final List craftTagReferences = CraftTagReferenceList.this.getCraftTagReferences();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CraftTagReferenceList.this.viewer.setInput((Object)craftTagReferences);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    @Override
    public void itemSelected() {
        this.refreshCraftTagReferencesList();
    }

    private void createPracticesListComponent() {
        this.group = new Group(this.compositeParent, 2816);
        GridLayout layout = new GridLayout(2, false);
        this.group.setLayout((Layout)layout);
        this.addSearchPracticeText();
        this.createViewer();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.addLayoutToTableViewer();
        this.practiceFilter = new CraftTagReferenceFilter();
        this.viewer.addFilter((ViewerFilter)this.practiceFilter);
    }

    private void addLayoutToTableViewer() {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void addSearchPracticeText() {
        Label searchLabel = new Label((Composite)this.group, 0);
        searchLabel.setText("Search: ");
        final Text searchText = new Text((Composite)this.group, 2176);
        searchText.setLayoutData((Object)new GridData(768));
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                CraftTagReferenceList.this.practiceFilter.setSearchText(searchText.getText());
                CraftTagReferenceList.this.viewer.refresh();
            }
        });
    }

    public Control getControl() {
        return this.group;
    }

    private List<CraftTagReference> getCraftTagReferences() {
        return this.craftTagReferenceRepo.getAllCraftTagReferences();
    }

    private void createViewer() {
        this.viewer = new TableViewer((Composite)this.group, 68356);
        String[] titles = new String[]{"Space", "Name", "Categories"};
        int[] bounds = new int[]{175, 500, 300};
        TableViewerColumn colPracticeSpaceName = this.createTableViewerColumn(titles[0], bounds[0], 0);
        colPracticeSpaceName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                CraftTagReference p = (CraftTagReference)element;
                return p.getSpace().getName();
            }
        });
        TableViewerColumn colPracticeName = this.createTableViewerColumn(titles[1], bounds[1], 1);
        colPracticeName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                CraftTagReference p = (CraftTagReference)element;
                return p.getName();
            }
        });
        TableViewerColumn colPracticeCategories = this.createTableViewerColumn(titles[2], bounds[2], 2);
        colPracticeCategories.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                CraftTagReference p = (CraftTagReference)element;
                return Arrays.asList(p.getCategories()).stream().sorted(String::compareTo).collect(Collectors.joining(", "));
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                CraftTagReference craftTagReference = (CraftTagReference)selection.getFirstElement();
                CraftTagReferenceDetail modal = new CraftTagReferenceDetail(CraftTagReferenceList.this.compositeParent.getShell(), craftTagReference);
                modal.create();
                modal.open();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 16448);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    @Focus
    public void setFocus() {
        this.group.setFocus();
    }
}

