/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.tabview;

import com.google.common.base.Strings;
import com.promyze.appli.service.EclipseService;
import com.promyze.appli.service.UrlService;
import com.promyze.domain.entity.CraftWorkshopSession;
import com.promyze.domain.exception.AbstractPromyzeException;
import com.promyze.domain.repository.ICraftWorkshopSessionRepo;
import com.promyze.infra.settings.PromyzePrefPage;
import com.promyze.ui.notification.PromyzeNotifier;
import com.promyze.ui.tabview.TabItemListener;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class WorkshopSessionList
extends ViewPart
implements TabItemListener {
    private ICraftWorkshopSessionRepo craftWorkshopSessionRepo;
    private TableViewer viewer;
    private Composite compositeList;
    private Group group;
    private PromyzePrefPage promyzePrefPage = new PromyzePrefPage();

    public WorkshopSessionList(ICraftWorkshopSessionRepo craftWorkshopSessionRepo) {
        this.craftWorkshopSessionRepo = craftWorkshopSessionRepo;
    }

    public void createPartControl(Composite parent) {
        this.compositeList = parent;
        this.createWorkshopListComponent();
        this.refreshCraftWorkshopsList();
    }

    protected boolean isPromyzeConfigured() {
        return !Strings.isNullOrEmpty((String)this.promyzePrefPage.getApiKeyValue());
    }

    private void refreshCraftWorkshopsList() {
        if (!this.isPromyzeConfigured()) {
            return;
        }
        Job job = new Job("Refresh Craft Workshops"){

            protected IStatus run(IProgressMonitor monitor) {
                final List currentCraftWorkshopSessions = WorkshopSessionList.this.getCraftWorkshopSessions();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkshopSessionList.this.viewer.setInput((Object)currentCraftWorkshopSessions);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    @Override
    public void itemSelected() {
        this.refreshCraftWorkshopsList();
    }

    private void createWorkshopListComponent() {
        this.group = new Group(this.compositeList, 2816);
        GridLayout layout = new GridLayout(1, false);
        this.group.setLayout((Layout)layout);
        this.createViewer();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.addLayoutToTableViewer();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    private void addLayoutToTableViewer() {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private List<CraftWorkshopSession> getCraftWorkshopSessions() {
        return this.craftWorkshopSessionRepo.getCraftWorkshopSessionsWithStepOnWorkshop();
    }

    private void createViewer() {
        this.viewer = new TableViewer(this.compositeList, 68356);
        String[] titles = new String[]{"Space", "Workshop name"};
        int[] bounds = new int[]{300, 500};
        TableViewerColumn colWorkshopSpaceName = this.createTableViewerColumn(titles[0], bounds[0], 0);
        colWorkshopSpaceName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                CraftWorkshopSession p = (CraftWorkshopSession)element;
                return p.getSpace().getName();
            }
        });
        TableViewerColumn colWorkshopPracticeName = this.createTableViewerColumn(titles[1], bounds[1], 1);
        colWorkshopPracticeName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                CraftWorkshopSession p = (CraftWorkshopSession)element;
                return p.getName();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                CraftWorkshopSession session = (CraftWorkshopSession)selection.getFirstElement();
                try {
                    String craftWorkshopSessionUrl = UrlService.getUrlForCraftWorkshopSession(session);
                    EclipseService.openBrowser(craftWorkshopSessionUrl);
                }
                catch (AbstractPromyzeException exception) {
                    PromyzeNotifier.notifyPromyzeError(exception);
                }
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 16448);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    @Focus
    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }
}

