/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.appli.service;

import com.google.common.base.Strings;
import com.promyze.appli.service.SettingsService;
import com.promyze.domain.entity.CraftTagReference;
import com.promyze.domain.entity.CraftWorkshopSession;
import com.promyze.domain.entity.Entity;
import com.promyze.infra.exception.ApiKeyException;

public class UrlService {
    public static String getCommonUrlForBack() throws ApiKeyException {
        return String.valueOf(UrlService.getRootUrlForPromyze()) + "/api/plugin/common";
    }

    public static String getSpecificBrowserUrlForBack() throws ApiKeyException {
        return String.valueOf(UrlService.getRootUrlForPromyze()) + "/api/plugin/browser";
    }

    public static String getSpecificIdeUrlForBack() throws ApiKeyException {
        return String.valueOf(UrlService.getRootUrlForPromyze()) + "/api/plugin/ide";
    }

    public static String getUrlForCraftWorkshopSession(CraftWorkshopSession craftWorkshopSession) throws ApiKeyException {
        return String.valueOf(UrlService.getRootUrlForFront()) + "/" + craftWorkshopSession.getSpace().getNameForUrl() + "/craft-workshop/app?craftWorkshopSession=" + craftWorkshopSession.get_id();
    }

    public static String getUrlForCraftTagReference(Entity craftTagReference) throws ApiKeyException {
        return String.valueOf(UrlService.getRootUrlForFront()) + "/" + craftTagReference.getSpace().getNameForUrl() + "/home?practiceId=" + craftTagReference.get_id();
    }

    public static String getUrlForCraftTagReferenceBattle(CraftTagReference craftTagReference) throws ApiKeyException {
        return String.valueOf(UrlService.getRootUrlForFront()) + "/" + craftTagReference.getSpace().getNameForUrl() + "/home?practiceId=" + craftTagReference.get_id() + "&inBattle=true";
    }

    public static String getRootUrlForFront() throws ApiKeyException {
        return String.valueOf(UrlService.getRootUrlForPromyze()) + "/#";
    }

    private static String getRootUrlForPromyze() throws ApiKeyException {
        String host = SettingsService.getHost();
        if (Strings.isNullOrEmpty((String)host)) {
            throw new ApiKeyException();
        }
        boolean isSecure = SettingsService.getIsSecured();
        String protocol = isSecure ? "https" : "http";
        return String.valueOf(protocol) + "://" + host;
    }
}

