/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.appli.service.api;

import com.promyze.appli.service.SettingsService;
import com.promyze.domain.error.ErrorMessage;
import com.promyze.domain.exception.AbstractPromyzeException;
import com.promyze.domain.service.IApiService;
import com.promyze.infra.exception.ApiKeyException;
import com.promyze.infra.exception.ConnectionException;
import com.promyze.infra.exception.ExceptionUtils;
import com.promyze.infra.exception.ForbiddenException;
import com.promyze.infra.exception.NotFoundException;
import com.promyze.infra.exception.PaymentRequiredException;
import com.promyze.infra.exception.UnexpectedException;
import com.promyze.infra.repository.PromyzeJSONAdapters;
import com.promyze.ui.notification.PromyzeNotifier;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class ApiService
implements IApiService {
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private OkHttpClient client;
    private String apiKey;
    private String rootUrl;

    protected ApiService() {
        this.updateHttpClient();
    }

    public void updateHttpClient() {
        try {
            this.client = this.getClient();
            this.apiKey = SettingsService.getApiKey();
            this.rootUrl = this.getRootUrlForBack();
        }
        catch (ApiKeyException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String get(String url) throws AbstractPromyzeException {
        Request request = new Request.Builder().url(String.valueOf(this.rootUrl) + "/" + url).addHeader("promyze-api-key", this.apiKey).addHeader("packmind-source-type", "IDE").addHeader("packmind-source-provider", "Eclipse").addHeader("Accept", "application/json").build();
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (Response response = this.client.newCall(request).execute();){
                this.handleResponse(response);
                return response.body().string();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw new ConnectionException("Error during request reading - " + ExceptionUtils.getExceptionStackTrace(exception));
        }
        catch (AbstractPromyzeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ConnectionException(ExceptionUtils.getExceptionStackTrace(exception));
        }
    }

    @Override
    public String post(String url, Object payload) throws AbstractPromyzeException {
        RequestBody body = RequestBody.create((String)payload.toString(), (MediaType)JSON);
        Request request = new Request.Builder().url(String.valueOf(this.rootUrl) + "/" + url).addHeader("promyze-api-key", this.apiKey).addHeader("packmind-source-type", "IDE").addHeader("packmind-source-provider", "Eclipse").addHeader("Accept", "application/json").post(body).build();
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (Response response = this.client.newCall(request).execute();){
                this.handleResponse(response);
                return response.body().string();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw new ConnectionException("Error during request reading - " + ExceptionUtils.getExceptionStackTrace(exception));
        }
        catch (AbstractPromyzeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ConnectionException(ExceptionUtils.getExceptionStackTrace(exception));
        }
    }

    @Override
    public String put(String url, Object payload) throws AbstractPromyzeException {
        RequestBody body = RequestBody.create((String)payload.toString(), (MediaType)JSON);
        Request request = new Request.Builder().url(String.valueOf(this.rootUrl) + "/" + url).addHeader("promyze-api-key", this.apiKey).addHeader("packmind-source-type", "IDE").addHeader("packmind-source-provider", "Eclipse").addHeader("Accept", "application/json").put(body).build();
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (Response response = this.client.newCall(request).execute();){
                this.handleResponse(response);
                return response.body().string();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw new ConnectionException("Error during request reading - " + ExceptionUtils.getExceptionStackTrace(exception));
        }
        catch (AbstractPromyzeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ConnectionException(ExceptionUtils.getExceptionStackTrace(exception));
        }
    }

    private OkHttpClient getClient() throws ApiKeyException {
        return new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).callTimeout(20L, TimeUnit.SECONDS).build();
    }

    private Response handleResponse(Response response) throws AbstractPromyzeException {
        if (!response.isSuccessful()) {
            if (response.code() < 400) {
                return response;
            }
            if (response.code() == 402) {
                try {
                    ErrorMessage errorMessage = (ErrorMessage)PromyzeJSONAdapters.errorMessage.fromJson(response.body().string());
                    throw new PaymentRequiredException(errorMessage.getMessage());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new PaymentRequiredException();
                }
            }
            if (response.code() == 403) {
                String message = "No additional details provided";
                if (response.message() != null) {
                    message = String.valueOf(message) + response.message();
                }
                if (response.body() != null) {
                    try {
                        message = String.valueOf(message) + " - " + response.body().string();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw new ForbiddenException(message);
            }
            if (response.code() == 404) {
                throw new NotFoundException();
            }
            if (response.code() == 502 || response.code() == 504) {
                throw new ConnectionException(this.extractErrorMessage(response));
            }
            throw new UnexpectedException(this.extractErrorMessage(response));
        }
        PromyzeNotifier.resetServerErrorNotification();
        return response;
    }

    private String extractErrorMessage(Response response) {
        try {
            String errorMessage = response.body().string();
            return String.valueOf(response.code()) + " " + errorMessage;
        }
        catch (IOException e) {
            e.printStackTrace();
            return String.valueOf(response.code()) + " " + e.getMessage();
        }
    }

    protected abstract String getRootUrlForBack() throws ApiKeyException;
}

