/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.domain.entity.helpers;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.promyze.domain.entity.helpers.Line;
import com.promyze.domain.entity.helpers.Position;
import java.util.List;

public class PositiveNegativeExamples {
    private List<Example> negative;
    private List<Example> positive;

    public List<Example> getNegative() {
        return this.negative;
    }

    public void setNegative(List<Example> negative) {
        this.negative = negative;
    }

    public List<Example> getPositive() {
        return this.positive;
    }

    public void setPositive(List<Example> positive) {
        this.positive = positive;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Example {
        private Position position;
        private FileWorkshopPreview fileWorkshopPreview;

        public Position getPosition() {
            return this.position;
        }

        public void setPosition(Position position) {
            this.position = position;
        }

        public FileWorkshopPreview getFileWorkshopPreview() {
            return this.fileWorkshopPreview;
        }

        public void setFileWorkshopPreview(FileWorkshopPreview fileWorkshopPreview) {
            this.fileWorkshopPreview = fileWorkshopPreview;
        }

        public String getExampleContent() {
            StringBuilder exampleContent = new StringBuilder();
            for (Line line : this.fileWorkshopPreview.getContents()) {
                String contentFormatted = line.getContent().replaceAll("\\r", "").replaceAll("\\n", "");
                exampleContent.append(contentFormatted);
                exampleContent.append("\n");
            }
            return exampleContent.toString();
        }

        public String getLang() {
            return this.fileWorkshopPreview.getLang();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static class FileWorkshopPreview {
            private String path;
            private String lang;
            private List<Line> contents;

            private FileWorkshopPreview() {
            }

            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public String getLang() {
                return this.lang != null ? this.lang : this.extractExtensionFromPath();
            }

            public void setLang(String lang) {
                this.lang = lang;
            }

            public List<Line> getContents() {
                return this.contents;
            }

            public void setContents(List<Line> contents) {
                this.contents = contents;
            }

            private String extractExtensionFromPath() {
                String[] pathSplit = this.path.split("\\.");
                return pathSplit.length > 0 ? pathSplit[pathSplit.length - 1] : null;
            }
        }
    }
}

