/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.infra.repository;

import com.promyze.appli.service.api.CommonApiService;
import com.promyze.domain.entity.FileWorkshop;
import com.promyze.domain.entity.Space;
import com.promyze.domain.exception.AbstractPromyzeException;
import com.promyze.domain.repository.ISpaceRepo;
import com.promyze.domain.service.IApiService;
import com.promyze.infra.exception.UnexpectedException;
import com.promyze.infra.repository.PromyzeJSONAdapters;
import com.promyze.ui.dialog.TagPracticeDialogResult;
import com.promyze.ui.notification.PromyzeNotifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SpaceRepo
implements ISpaceRepo {
    private final String spaceBaseUrl = "space";
    private final IApiService apiService = CommonApiService.getInstance();

    @Override
    public List<Space> getAllSpaces() {
        try {
            return (List)PromyzeJSONAdapters.spaceList.fromJson(this.apiService.get("space"));
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return new ArrayList<Space>();
        }
        catch (IOException exception) {
            PromyzeNotifier.notifyPromyzeError(new UnexpectedException(exception.getMessage()));
            return new ArrayList<Space>();
        }
    }

    @Override
    public boolean addSnippetToSession(FileWorkshop fileWorkshop, Space space) {
        try {
            this.apiService.post("space/add-snippet/" + space.get_id(), PromyzeJSONAdapters.fileWorkshop.toJson((Object)fileWorkshop));
            return true;
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return false;
        }
    }

    @Override
    public String addPracticeToSession(TagPracticeDialogResult payload) {
        try {
            String craftTagId = this.apiService.post("space/add-practice", PromyzeJSONAdapters.tagPracticeDialogResult.toJson((Object)payload));
            return craftTagId.startsWith("\"") && craftTagId.endsWith("\"") ? craftTagId.replaceAll("\"", "") : craftTagId;
        }
        catch (AbstractPromyzeException exception) {
            PromyzeNotifier.notifyPromyzeError(exception);
            return null;
        }
    }
}

