/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.command;

import com.google.common.base.Strings;
import com.promyze.domain.entity.CraftTagReference;
import com.promyze.domain.entity.Space;
import com.promyze.domain.repository.ICraftTagReferenceRepo;
import com.promyze.domain.repository.ISpaceRepo;
import com.promyze.ui.command.CraftTagKindSelection;
import com.promyze.ui.notification.PromyzeNotifier;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddCraftTagDialogExistingPractice
extends TitleAreaDialog {
    private Combo spacesList;
    private Combo craftTagReferenceList;
    private Space space;
    private CraftTagReference craftTagReference;
    private List<Space> spaces;
    private List<CraftTagReference> currentCraftTagReferences;
    private ISpaceRepo spaceRepo;
    private ICraftTagReferenceRepo craftTagReferenceRepo;
    private CraftTagKindSelection craftTagKindSelection;

    public AddCraftTagDialogExistingPractice(Shell parentShell, ISpaceRepo spaceRepo, ICraftTagReferenceRepo craftTagReferenceRepo) {
        super(parentShell);
        this.spaceRepo = spaceRepo;
        this.craftTagReferenceRepo = craftTagReferenceRepo;
    }

    public void create() {
        super.create();
        this.setTitle("Packmind");
        this.setMessage("Send selection as an existing practice example", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.spaces = this.spaceRepo.getAllSpaces();
        if (this.spaces.isEmpty()) {
            PromyzeNotifier.notifyUserError("You don't have any space yet in your organization. Please create or join an existing space");
            area.dispose();
            return area;
        }
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.initSpaceComboList(container);
        this.initCraftTagReferenceComboList(container);
        this.craftTagKindSelection = new CraftTagKindSelection();
        this.craftTagKindSelection.setPositiveNegativeRadioTag(container);
        this.updateValidationButtonStatus();
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Send example to Packmind", false);
        this.getButton(0).setEnabled(false);
        this.getButton(0).setTouchEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void updateValidationButtonStatus() {
        if (this.getButton(0) != null) {
            if (this.space == null || this.craftTagReference == null) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        } else {
            System.err.println("OK_ID button is null");
        }
    }

    public void initSpaceComboList(Composite container) {
        Label spaceLabel = new Label(container, 0);
        spaceLabel.setText("Space");
        this.spacesList = new Combo(container, 4);
        GridData dataSpace = new GridData();
        dataSpace.grabExcessHorizontalSpace = true;
        dataSpace.horizontalAlignment = 4;
        this.spacesList.setLayoutData((Object)dataSpace);
        this.spaces.stream().sorted((s1, s2) -> s1.getName().compareTo(s2.getName())).forEach(s -> this.spacesList.add(s.getName()));
        this.spacesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddCraftTagDialogExistingPractice.this.space = AddCraftTagDialogExistingPractice.this.getSpaceFromName(((Combo)e.getSource()).getText());
                if (AddCraftTagDialogExistingPractice.this.space != null) {
                    AddCraftTagDialogExistingPractice.this.updatePracticesList(AddCraftTagDialogExistingPractice.this.space);
                }
                AddCraftTagDialogExistingPractice.this.updateValidationButtonStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Space getSpaceFromName(String spaceName) {
        if (Strings.isNullOrEmpty((String)spaceName)) {
            return null;
        }
        return this.spaces.stream().filter(s -> s.getName().equals(spaceName)).findFirst().get();
    }

    public void initCraftTagReferenceComboList(Composite container) {
        Label craftTagLabel = new Label(container, 0);
        craftTagLabel.setText("Practice");
        this.craftTagReferenceList = new Combo(container, 4);
        GridData dataCraftTagReference = new GridData();
        dataCraftTagReference.grabExcessHorizontalSpace = true;
        dataCraftTagReference.horizontalAlignment = 4;
        this.craftTagReferenceList.setLayoutData((Object)dataCraftTagReference);
        this.craftTagReferenceList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String craftTagReferenceText = ((Combo)e.getSource()).getText();
                CraftTagReference selectedCraftTagReference = AddCraftTagDialogExistingPractice.this.getCraftTagReferenceFromName(craftTagReferenceText);
                if (selectedCraftTagReference != null) {
                    AddCraftTagDialogExistingPractice.this.craftTagReference = selectedCraftTagReference;
                } else {
                    System.err.println("Could not find selectedCraftTagReference");
                }
                AddCraftTagDialogExistingPractice.this.updateValidationButtonStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.space != null) {
            this.updatePracticesList(this.space);
        }
    }

    private CraftTagReference getCraftTagReferenceFromName(String craftTagReferenceName) {
        if (Strings.isNullOrEmpty((String)craftTagReferenceName)) {
            return null;
        }
        return this.currentCraftTagReferences.stream().filter(s -> s.getName().equals(craftTagReferenceName)).findFirst().get();
    }

    private void updatePracticesList(Space space) {
        this.craftTagReferenceList.removeAll();
        this.currentCraftTagReferences = this.craftTagReferenceRepo.getAllCraftTagReferencesInSpace(space.get_id());
        this.currentCraftTagReferences.stream().sorted((c1, c2) -> c1.getName().compareTo(c2.getName())).forEach(c -> this.craftTagReferenceList.add(c.getName()));
    }

    protected boolean isResizable() {
        return true;
    }

    public Space getSpace() {
        return this.space;
    }

    public CraftTagReference getCraftTagReference() {
        return this.craftTagReference;
    }

    public boolean isPositive() {
        return this.craftTagKindSelection.isCurrentCraftTagPositive();
    }
}

