/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.notification;

import com.promyze.domain.exception.AbstractPromyzeException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PromyzeNotifier {
    private static boolean hasAlreadyNotifiedAServerError = false;

    public static void notifyPromyzeError(AbstractPromyzeException exception) {
        if (!hasAlreadyNotifiedAServerError) {
            hasAlreadyNotifiedAServerError = true;
            PromyzeNotifier.notifyUserError(String.valueOf(exception.getClass().getCanonicalName()) + " " + exception.getMessage());
        }
    }

    public static void notifyUserSuccess(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Packmind", (String)message);
            }
        });
    }

    public static void notifyUserWarning(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Packmind", (String)message);
            }
        });
    }

    public static void notifyUserError(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Packmind", (String)message);
            }
        });
    }

    public static void resetServerErrorNotification() {
        hasAlreadyNotifiedAServerError = false;
    }
}

