/*
 * Decompiled with CFR 0.152.
 */
package com.promyze.ui.tabview;

import com.promyze.appli.service.PromyzeInfraService;
import com.promyze.domain.repository.ICraftTagReferenceRepo;
import com.promyze.domain.repository.ICraftWorkshopSessionRepo;
import com.promyze.ui.tabview.BattleList;
import com.promyze.ui.tabview.CraftTagReferenceList;
import com.promyze.ui.tabview.TabItemListener;
import com.promyze.ui.tabview.WorkshopSessionList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

public class PromyzeView
extends ViewPart
implements FocusListener,
IPartListener2 {
    private TabFolder folder;
    private ICraftTagReferenceRepo craftTagReferenceRepo = PromyzeInfraService.getCraftTagReferenceRepo();
    private ICraftWorkshopSessionRepo workshopRepo = PromyzeInfraService.getCraftWorkshopSessionRepo();
    private Map<String, TabItemListener> tabIndex = new HashMap<String, TabItemListener>();

    @PostConstruct
    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.folder = new TabFolder(parent, 0);
        this.configurePracticesListTab(this.folder);
        this.configureWorkshopsTab(this.folder);
        this.configureBattlesTab(this.folder);
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String tabText = PromyzeView.this.folder.getSelection()[0].getText();
                ((TabItemListener)PromyzeView.this.tabIndex.get(tabText)).itemSelected();
            }
        });
    }

    private void configurePracticesListTab(TabFolder folder) {
        TabItem tabPracticesList = new TabItem(folder, 0);
        tabPracticesList.setText("Your practices");
        CraftTagReferenceList practicesListDisplay = new CraftTagReferenceList(this.craftTagReferenceRepo);
        practicesListDisplay.createPartControl((Composite)folder);
        tabPracticesList.setControl(practicesListDisplay.getControl());
        this.tabIndex.put("Your practices", practicesListDisplay);
    }

    private void configureBattlesTab(TabFolder folder) {
        TabItem tabBattles = new TabItem(folder, 0);
        tabBattles.setText("Battles");
        BattleList battleListDisplay = new BattleList(this.craftTagReferenceRepo);
        battleListDisplay.createPartControl((Composite)folder);
        tabBattles.setControl(battleListDisplay.getControl());
        this.tabIndex.put("Battles", battleListDisplay);
    }

    private void configureWorkshopsTab(TabFolder folder) {
        TabItem tabWorkshops = new TabItem(folder, 0);
        tabWorkshops.setText("Workshops");
        WorkshopSessionList workshopListDisplay = new WorkshopSessionList(this.workshopRepo);
        workshopListDisplay.createPartControl((Composite)folder);
        tabWorkshops.setControl(workshopListDisplay.getControl());
        this.tabIndex.put("Workshops", workshopListDisplay);
    }

    @Focus
    public void setFocus() {
        if (this.folder != null) {
            this.folder.setFocus();
        }
    }

    @Inject
    @Optional
    public void setSelection(@Named(value="org.eclipse.ui.selection") ISelection s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        if (s instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)s;
            if (iss.size() == 1) {
                this.setSelection(iss.getFirstElement());
            } else {
                this.setSelection(iss.toArray());
            }
        }
    }

    @Inject
    @Optional
    public void setSelection(@Named(value="org.eclipse.ui.selection") Object o) {
        if (o instanceof ISelection) {
            return;
        }
    }

    @Inject
    @Optional
    public void setSelection(@Named(value="org.eclipse.ui.selection") Object[] selectedObjects) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

